import React from 'react';
import {render} from 'react-dom';
import {Provider} from 'react-redux';
import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import * as reducers from './reducers';
import certs from './redux/ducks/certs';
import certRequestForm from './redux/ducks/cert-request-form';
import cert from './redux/ducks/cert';
import {middleware as reduxFetch} from 'tools-access-react-redux/src/fetch';
import Fetcher from 'tools-access-react-redux/src/utils/fetcher';
import {REQUEST} from './actions/fetch';
import routerReducer, {GET_STORE_PATH} from 'tools-access-react-redux-router/src/reducer';
import history from 'tools-access-react-redux-router/src/history';

import RoutesSC from 'b:routes.store-connected';

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;

const reducer = combineReducers({
    ...reducers,
    [GET_STORE_PATH]: routerReducer,
    certs,
    certRequestForm,
    cert
});
const middlewares = applyMiddleware(
    history(),
    thunkMiddleware,
    reduxFetch({
        type: REQUEST,
        client: new Fetcher.Request()
    })
);
const store = createStore(reducer, composeEnhancers(middlewares));
const content = (
    <Provider store={store}>
        <RoutesSC />
    </Provider>
);

render(content, document.getElementById('react-root'));
