/* global process */

const lang = process.env.BEM_LANG;

import {handleAction} from 'redux-actions';

import {
    ENABLE_SCROLL,
    DISABLE_SCROLL
} from './actions/page-scroll';

import {SET_USER_DATA} from './actions/user-data';

export function pageScroll(state = true, action) {
    switch (action.type) {
        case DISABLE_SCROLL:
            return false;
        case ENABLE_SCROLL:
            return true;
        default:
            return state;
    }
}

export function pageTitle(state = lang === 'ru' ? 'Сертификатор' : 'Certificater') {
    return state;
}

export function pageLang(state = lang) {
    return state;
}

export const userData = handleAction(
    SET_USER_DATA,
    (state, {payload}) => payload,
    {
        username: '',
        email: '',
        lang_ui: '',
        first_name: {
            ru: '',
            en: ''
        },
        last_name: {
            ru: '',
            en: ''
        }
    }
);
