import {handleActions, createAction} from 'redux-actions';
import {request} from '../../actions/fetch';
import {update} from 'tools-access-react/src/utils/update';
import {createStructuredSelector} from 'reselect';

const RECEIVE_ADDITIONAL_FIELDS_CONFIG = 'RECEIVE_ADDITIONAL_FIELDS_CONFIG';
const CLEAR_ADDITIONAL_FIELDS_CONFIG = 'CLEAR_ADDITIONAL_FIELDS_CONFIG';
const RECEIVE_CREATE_CERT = 'RECEIVE_CREATE_CERT';

export default handleActions({
    [RECEIVE_ADDITIONAL_FIELDS_CONFIG]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return {
            ...state,
            additionalFieldsConfig: payload
        };
    },
    [RECEIVE_CREATE_CERT]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return state;
    },
    [CLEAR_ADDITIONAL_FIELDS_CONFIG]: (state) => ({
        ...state,
        additionalFieldsConfig: []
    })
}, {additionalFieldsConfig: []});

export function requestAdditionalFieldsConfig(ca_name, type) {
    const params = update({
        pathname: '/api/frontend/fields/',
        credentials: 'include',
        query: {ca_name, type}
    });

    return request(params, RECEIVE_ADDITIONAL_FIELDS_CONFIG);
}

export const clearAdditionalFieldsConfig = createAction(CLEAR_ADDITIONAL_FIELDS_CONFIG);

export function requestCreateCert(data) {
    const params = update({
        method: 'POST',
        pathname: '/api/frontend/certificates/',
        credentials: 'include',
        data
    });

    return request(params, RECEIVE_CREATE_CERT);
}

const certRequestForm = (state) => state.certRequestForm;

export const selector = createStructuredSelector({certRequestForm});
