/* global process */

import {handleActions} from 'redux-actions';
import {request} from '../../actions/fetch';
import {update} from 'tools-access-react/src/utils/update';
import {createStructuredSelector} from 'reselect';

const {BEM_LANG} = process.env;

const RECEIVE_CERT = 'RECEIVE_CERT';
const RECEIVE_CERT_ACTION = 'RECEIVE_CERT_ACTION';
const RECEIVE_UPDATE_ABC_SERVICE = 'RECEIVE_UPDATE_ABC_SERVICE';
const RECEIVE_ADDITIONAL_FIELDS_CONFIG = 'RECEIVE_ADDITIONAL_FIELDS_CONFIG';

export default handleActions({
    [RECEIVE_CERT]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return payload;
    },
    [RECEIVE_CERT_ACTION]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return payload;
    },
    [RECEIVE_UPDATE_ABC_SERVICE]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return payload;
    },
    [RECEIVE_ADDITIONAL_FIELDS_CONFIG]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return {
            ...state,
            additionalFieldsConfig: payload
        };
    }
}, {
    available_actions: [],
    serial_number: '',
    common_name: '',
    ca_name: '',
    type_human: {[BEM_LANG]: ''},
    status_human: {[BEM_LANG]: ''},
    device_platform: '',
    end_date: '',
    hosts: [],
    id: 0,
    request_id: '',
    requester: {username: ''},
    added: '',
    user: {username: ''},
    abc_service: {},
    issued: '',
    grantedAt: '',
    used_template: '',
    tags: [],
    priv_key_deleted_at: ''
});

export function requestCert(id) {
    const params = update({
        credentials: 'include',
        pathname: `/api/frontend/certificate/${encodeURIComponent(id)}/`
    });

    return request(params, RECEIVE_CERT);
}

export function requestCertAction(id, action) {
    const params = update({
        method: 'POST',
        credentials: 'include',
        pathname: `/api/frontend/certificate/${encodeURIComponent(id)}/operations/`,
        data: {action}
    });

    return request(params, RECEIVE_CERT_ACTION);
}

export function requestUpdateAbcService(id, abc_service) {
    const params = update({
        method: 'PATCH',
        credentials: 'include',
        pathname: `/api/frontend/certificate/${encodeURIComponent(id)}/`,
        data: {abc_service}
    });

    return request(params, RECEIVE_UPDATE_ABC_SERVICE);
}

export function requestAdditionalFieldsConfig(ca_name, type) {
    const params = update({
        pathname: '/api/frontend/fields/',
        credentials: 'include',
        query: {ca_name, type}
    });

    return request(params, RECEIVE_ADDITIONAL_FIELDS_CONFIG);
}

const cert = (state) => state.cert;

export const selector = createStructuredSelector({cert});
