import {handleActions} from 'redux-actions';
import {request} from '../../actions/fetch';
import {update} from 'tools-access-react/src/utils/update';
import {createSelector, createStructuredSelector} from 'reselect';

const RECEIVE_CERTS = 'RECEIVE_CERTS';

export default handleActions({
    [RECEIVE_CERTS]: (state, {payload, error}) => {
        if (error) {
            throw payload;
        }

        return {
            ...state,
            items: payload.results,
            count: payload.count,
            page: payload.page
        };
    }
}, {
    items: [],
    count: 0,
    page: 0,
    perPage: 10,
    additionalFiltersName: [
        'ca_name',
        'requester',
        'host',
        'serial_number',
        'abc_service'
    ],
    mainFiltersName: [
        'type',
        'status',
        'user',
        'common_name'
    ]
});

export function requestCerts(query) {
    const params = update({
        credentials: 'include',
        pathname: '/api/frontend/certificates/',
        query: {
            _fields: [
                'serial_number',
                'ca_name',
                'common_name',
                'type_human',
                'requester',
                'status_human',
                'requested',
                'added',
                'issued',
                'end_date',
                'helpdesk_ticket'
            ].join(),
            ...query
        },
        name: 'request-certs'
    });

    return request(params, RECEIVE_CERTS);
}

const certs = (state) => state.certs;
const numberOfPages = createSelector(
    certs,
    ({count, perPage}) => Math.ceil(count / perPage)
);
const additionalFiltersKeys = createSelector(
    certs,
    ({additionalFiltersName}) => additionalFiltersName
);
const mainFiltersKeys = createSelector(
    certs,
    ({mainFiltersName}) => mainFiltersName
);

const filtersKeys = createSelector(
    certs,
    ({additionalFiltersName, mainFiltersName}) => [...additionalFiltersName, ...mainFiltersName]
);

export const selector = createStructuredSelector({
    certs,
    numberOfPages,
    additionalFiltersKeys,
    mainFiltersKeys,
    filtersKeys
});
