'use strict';

const path = require('path');
const defaultConfig = require('@yandex-int/clement/default-config');
const pluginFilePath = require('./plugins/cache-filepath');
const pluginFileName = require('./plugins/cache-filename');
const pluginAddFinalSlash = require('./plugins/add-final-slash');
const justUpdated = require('./plugins/just-updated');

module.exports = {
    cachePath: path.join(__dirname, './cache/'),
    plugins: [
        pluginFilePath,
        pluginFileName,
        pluginAddFinalSlash,
        justUpdated,
        ...defaultConfig.plugins
    ],
    sources: {
        3333: {
            url: 'https://crt.test.yandex-team.ru'
        }
    }
};
