'use strict';

const crypto = require('crypto');

const pluginFilename = (ctx, next) => {
    if (!ctx.cache.key || ctx.cache.filename) {
        next();

        return;
    }

    const hash = crypto.createHash('sha256').update(ctx.cache.key).digest('hex');
    const method = String(ctx.sourceReq.method).toLowerCase();

    ctx.cache.filename = `${method}_${hash}.json.gz`;

    next();
};

module.exports = {
    'cache-filename': pluginFilename
};
