'use strict';

const path = require('path');
const cookieParse = require('cookie').parse;

const pluginFilePath = (ctx, next) => {
    if (!ctx.cache.key || ctx.cache.filepath) {
        next();

        return;
    }

    let dumpsPath = ctx.cfg.cachePath;

    if (ctx.sourceReq.headers.cookie) {
        const dumpsCookie = cookieParse(ctx.sourceReq.headers.cookie).dumps_test_path;

        if (dumpsCookie) {
            dumpsPath = dumpsCookie;
        }
    }

    ctx.cache.filepath = path.resolve(
        dumpsPath,
        ctx.sourceReq.host,
        String(ctx.sourceReq.path).slice(1)
    );

    next();
};

module.exports = {
    'cache-filepath': pluginFilePath
};
