'use strict';

const {parse: cookieParse} = require('cookie');

// Учитывает куку just_updated в формировании ключа кеша
// Кука ставится после "изменяющего" действия (запрос роли, подтверждение запроса и т.д.)
module.exports = {
    'cache-key': (ctx, next) => {
        const {just_updated: __just_updated__} = cookieParse(ctx.req.headers.cookie);

        if (__just_updated__) {
            ctx.req.parsedURL.query = Object.assign({}, ctx.req.parsedURL.query, {__just_updated__});
        }

        next();
    }
};
