/* global document */

'use strict';

function changeModalBackground() {
    return this.execute((color = '#000000') => {
        if (document.getElementById('changeModalBackground')) {
            return;
        }

        const style = document.createElement('style');

        style.id = 'changeModalBackground';
        style.textContent = `.modal_theme_normal
        {
            background: ${color} !important;
        }`;

        document.head.appendChild(style);
    }, ...arguments);
}

function restoreModalBackground() {
    return this.execute(() => {
        const style = document.getElementById('changeModalBackground');

        if (style) {
            style.parentNode.removeChild(style);
        }
    });
}

module.exports = {
    changeModalBackground,
    restoreModalBackground
};
