/* global document */

'use strict';

module.exports = function disableAnimations() {
    return this.execute((selector) => {
        const style = document.createElement('style');

        style.textContent = `${selector}
        {
            transition-property: none !important;
            -webkit-transition-property: none !important;

            animation-name: none !important;
            -webkit-animation-name: none !important;
        }`;

        document.head.appendChild(style);

    }, ...arguments);
};
