'use strict';

require('dotenv').config();

const {HERMIONE_USER, HERMIONE_PASS} = process.env;

const openIntranetPage = require('./open-intranet-page')
    .withCredentials({
        user: HERMIONE_USER,
        pass: HERMIONE_PASS
    });
const initClement = require('./init-clement');
const setSuggestVal = require('./set-suggest-val');
const disableAnimations = require('./disable-animations');
const {
    changeModalBackground,
    restoreModalBackground
} = require('./change-modal-background');

module.exports = {
    openIntranetPage,
    initClement,
    setSuggestVal,
    disableAnimations,
    changeModalBackground,
    restoreModalBackground
};
