'use strict';

const path = require('path');

module.exports = function initClement() {
    const {file, id, browserId} = Object(this.executionContext);
    const baseName = path.basename(file, '.hermione.js');

    if (!file) {
        throw new Error('Command "initClement" should be run only from the test context ("it" function body).');
    }

    const fullPath = path.join(
        path.dirname(file),
        `${baseName}.clement-cache`,
        id(),
        browserId
    );
    const rootDir = process.cwd();
    const testPath = fullPath.indexOf(rootDir) === 0 ? `.${fullPath.slice(rootDir.length)}` : fullPath;

    return this.setCookie({
        name: 'dumps_test_path',
        value: testPath,
        domain: '.yandex-team.ru',
        path: '/'
    });
};
