'use strict';

const {format: urlFormat, parse: urlParse} = require('url');

function openIntranetPage(urlObj, opts) {
    return this.switchTab().then(() => {
        const urlStr = urlFormat(urlObj);
        const {user, pass} = opts;

        if (!user) {
            throw new Error('Login is not defined');
        }

        if (!pass) {
            throw new Error(`Password is not defined for user ${user}`);
        }

        const aquaLoginUrl = urlParse('http://aqua.yandex-team.ru/auth.html', true);

        aquaLoginUrl.query.mode = 'auth';
        aquaLoginUrl.query.login = user;
        aquaLoginUrl.query.passwd = pass;

        return this.url(urlFormat(aquaLoginUrl))
            .waitForExist('body')
            .initClement()
            .url(urlStr);
    });
}

openIntranetPage.withCredentials = ({user, pass}) =>
    function (urlObj) {
        return openIntranetPage.call(this, urlObj, {user, pass});
    };

module.exports = openIntranetPage;
