'use strict';

const autoprefixer = require('autoprefixer');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const merge = require('webpack-merge');
const {config, getStyleLoaders} = require('./webpack.common');

const autoprefixerPlugin = autoprefixer();

const styleLoaders = getStyleLoaders(true, [autoprefixerPlugin]);

module.exports = merge.smart(config, {
    output: {
        publicPath: '.'
    },
    module: {
        rules: [
            {
                test: /\.css$/,
                use: styleLoaders
            },
            {
                test: /\.styl$/,
                use: [
                    ...styleLoaders,
                    {
                        loader: 'stylus-loader'
                    }
                ]
            },
            {
                test: /\.svg$/,
                use: [
                    'svgo-loader'
                ]
            }
        ]
    },
    plugins: [
        new UglifyJsPlugin({
            uglifyOptions: {
                ecma: 8,
                safari10: true
            }
        })
    ]
});
