PY3_LIBRARY(crt)

OWNER(g:walle)

PEERDIR(
    contrib/python/celery/py2
    contrib/python/contextdecorator
    contrib/python/contextlib2
    contrib/python/cryptography
    contrib/python/django/django-1.11
    contrib/python/django-constance/py2
    contrib/python/django-extensions/py2
    contrib/python/django-filter
    contrib/python/django-model-utils/py2
    contrib/python/django-picklefield
    contrib/python/django-replicated
    contrib/python/djangorestframework
    contrib/python/djangorestframework-xml
    contrib/python/django-waffle
    contrib/python/dnspython
    contrib/python/envoy
    contrib/python/freezegun
    contrib/python/mock
    contrib/python/pem
    contrib/python/pexpect
    contrib/python/psutil
    contrib/python/pyOpenSSL
    contrib/python/pytest
    contrib/python/python-ldap
    contrib/python/pytz
    contrib/python/requests
    contrib/python/setuptools
    contrib/python/zeep
    contrib/python/zero-downtime-migrations

    library/python/datasources-config-wrapper
    library/python/django
    library/python/django_abc_data
    library/python/django-idm-api
    library/python/django_pgaas
    library/python/django_tools_log_context
    library/python/granular_settings
    library/python/ids
    library/python/intrasearch_fetcher
    library/python/metrics_framework
    library/python/python-django-yauth
    library/python/vault_client
    library/python/yenv
    library/python/ylock
    library/python/ylog

    # development packages
    contrib/python/ipdb
    contrib/python/ipython

    intranet/crt/actions
    intranet/crt/api
    intranet/crt/core
    intranet/crt/metrics
    intranet/crt/tags
    intranet/crt/tasks
    intranet/crt/users
    intranet/crt/monitorings
)

PY_SRCS(
    __init__.py
    celery_app.py
    constants.py
    csr/__init__.py
    csr/base_config.py
    csr/config.py
    csr/fields.py
    exceptions.py
    manage.py
    settings.py
    urls.py
    utils/__init__.py
    utils/admin.py
    utils/base_command.py
    utils/ca.py
    utils/ca_export.py
    utils/constance.py
    utils/crl.py
    utils/cvs.py
    utils/dns.py
    utils/domain.py
    utils/environ.py
    utils/file.py
    utils/http.py
    utils/idm.py
    utils/iphone.py
    utils/iterable.py
    utils/ldap.py
    utils/lock.py
    utils/log.py
    utils/mobile.py
    utils/pgaas.py
    utils/publicsuffix.py
    utils/punicode.py
    utils/random.py
    utils/replication.py
    utils/ssl.py
    utils/staff.py
    utils/startrek.py
    utils/tags.py
    utils/test_ca.py
    utils/time.py
    utils/timestamp.py
)

RESOURCE_FILES(
    PREFIX intranet/crt/

    settings/000-constants.conf
    settings/001-paths.conf
    settings/001-paths.conf.development
    settings/001-paths.conf.development.unittest
    settings/001-paths.conf.testing
    settings/003-templates.conf
    settings/004-debug.conf
    settings/004-debug.conf.development
    settings/005-static.conf
    settings/007-idm.conf
    settings/010-apps.conf
    settings/011-logging.conf
    settings/011-logging.conf.development
    settings/015-datasources.conf.development
    settings/015-datasources.conf.development.unittest
    settings/015-datasources.conf.production
    settings/015-datasources.conf.testing
    settings/020-database.conf
    settings/020-database.conf.development
    settings/020-database.conf.development.unittest
    settings/020-database.conf.development.migration
    settings/025-constance.conf
    settings/030-security.conf
    settings/030-security.conf.development
    settings/030-security.conf.production
    settings/030-security.conf.testing
    settings/040-middleware.conf
    settings/040-middleware.conf.development
    settings/040-middleware.conf.development.unittest
    settings/045-yauth.conf
    settings/045-yauth.conf.development.unittest
    settings/046-ylock.conf
    settings/046-ylock.conf.development
    settings/046-ylock.conf.development.unittest
    settings/048-rest.conf
    settings/060-notifications.conf
    settings/060-notifications.conf.development
    settings/060-notifications.conf.testing
    settings/065-cvs.conf
    settings/065-cvs.conf.development
    settings/080-cache.conf
    settings/085-crt-urls.conf
    settings/085-crt-urls.conf.testing
    settings/090-crt.conf
    settings/090-crt.conf.development
    settings/090-crt.conf.development.unittest
    settings/091-import-oids.conf
    settings/091-import-oids.conf.testing
    settings/090-crt.conf.testing
    settings/099-misc.conf
    settings/100-celery.conf
    settings/100-celery.conf.development.unittest
    settings/115-abc.conf
    settings/120-metrics.conf
)

END()

RECURSE(
    wsgi
)

RECURSE_FOR_TESTS(
    tests
)
