package ru.yandex.intranet.d.dao;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.values.PrimitiveValue;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.datasource.Ydb;
import ru.yandex.intranet.d.datasource.impl.YdbQuerySource;
import ru.yandex.intranet.d.datasource.model.WithTxId;
import ru.yandex.intranet.d.datasource.model.YdbTxSession;
import ru.yandex.intranet.d.model.StringIdWithTenant;
import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.WithTenant;

/**
 * Abstract DAO with string id in ModelClass.
 *
 * @deprecated todo: replace by "{@code AbstractDao<ModelClass, String>}"
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 */
@Deprecated
public abstract class AbstractDaoWithStringId<ModelClass> extends AbstractDaoWithSoftRemove<ModelClass, String> {

    protected AbstractDaoWithStringId(YdbQuerySource ydbQuerySource) {
        super(ydbQuerySource);
    }

    @Override
    protected Params getIdentityParams(String id) {
        return Params.create().put(
                "$id", PrimitiveValue.utf8(id)
        );
    }

    @Override
    public Mono<List<ModelClass>> getByIds(YdbTxSession session, List<WithTenant<String>> ids) {
        List<StringIdWithTenant> stringIds = ids.stream()
                .map(id -> new StringIdWithTenant(id.getTenantId(), id.getIdentity()))
                .collect(Collectors.toList());
        return getByIds(session, Ydb.toIdWithTenantsListValue(stringIds)).map(WithTxId::get);
    }

    @Override
    public Mono<WithTxId<List<ModelClass>>> getByIdsStartTx(
            YdbTxSession session, List<String> ids, TenantId tenantId
    ) {
        List<StringIdWithTenant> stringIds = ids.stream()
                .map(id -> new StringIdWithTenant(tenantId, id))
                .collect(Collectors.toList());
        return getByIds(session, Ydb.toIdWithTenantsListValue(stringIds));
    }

    public Mono<Void> removeRetryable(YdbTxSession session, StringIdWithTenant stringIdWithTenant, long newVersion) {
        return removeRetryable(session, stringIdWithTenant.getId(), stringIdWithTenant.getTenantId(), newVersion);
    }

    @Override
    public Mono<WithTxId<Void>> removeAllRetryable(YdbTxSession session, List<WithTenant<String>> ids) {
        List<StringIdWithTenant> stringIds = ids.stream()
                .map(id -> new StringIdWithTenant(id.getTenantId(), id.getIdentity()))
                .collect(Collectors.toList());
        return removeAllRetryable(session, Ydb.toIdWithTenantsListValue(stringIds));
    }

    protected abstract StringIdWithTenant getIdWithTenant(ModelClass model);

    @Override
    protected WithTenant<String> getIdentityWithTenant(ModelClass model) {
        StringIdWithTenant stringIdWithTenant = getIdWithTenant(model);
        return new WithTenant<>(stringIdWithTenant.getTenantId(), stringIdWithTenant.getId());
    }
}
