package ru.yandex.intranet.d.dao

import com.yandex.ydb.table.query.DataQueryResult
import com.yandex.ydb.table.result.ResultSetReader

/**
 * DAO reader.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
class DaoReader private constructor() {
    companion object {
        fun <T> toModel(result: DataQueryResult, rowReader: (reader: ResultSetReader) -> T): T? {
            if (result.isEmpty) {
                return null
            }
            if (result.resultSetCount > 1) {
                throw IllegalStateException("Too many result sets")
            }
            return toModel(result.getResultSet(0), rowReader)
        }
        fun <T> toModelWithTx(result: DataQueryResult, rowReader: (reader: ResultSetReader) -> T): MaybeWithTx<T> {
            if (result.isEmpty) {
                return MaybeWithTx(null, result.txId)
            }
            if (result.resultSetCount > 1) {
                throw IllegalStateException("Too many result sets")
            }
            return MaybeWithTx(toModel(result.getResultSet(0), rowReader), result.txId)
        }
        fun <T> toModels(result: DataQueryResult, rowReader: (reader: ResultSetReader) -> T): List<T> {
            if (result.isEmpty) {
                return listOf()
            }
            if (result.resultSetCount > 1) {
                throw IllegalStateException("Too many result sets")
            }
            return toModels(result.getResultSet(0), rowReader)
        }
        fun <T> toModelsWithTx(result: DataQueryResult, rowReader: (reader: ResultSetReader) -> T): WithTx<List<T>> {
            if (result.isEmpty) {
                return WithTx(listOf(), result.txId)
            }
            if (result.resultSetCount > 1) {
                throw IllegalStateException("Too many result sets")
            }
            return WithTx(toModels(result.getResultSet(0), rowReader), result.txId)
        }
        fun <T> toModel(reader: ResultSetReader, rowReader: (reader: ResultSetReader) -> T): T? {
            if (!reader.next()) {
                return null
            }
            if (reader.rowCount > 1) {
                throw IllegalStateException("Non-unique result")
            }
            return rowReader(reader)
        }
        fun <T> toModels(reader: ResultSetReader, rowReader: (reader: ResultSetReader) -> T): List<T> {
            val result = mutableListOf<T>()
            while (reader.next()) {
                result.add(rowReader(reader))
            }
            return result.toList()
        }
    }
}

data class MaybeWithTx<T>(
    val value: T?,
    val txId: String
)

data class WithTx<T>(
    val value: T,
    val txId: String
)
