package ru.yandex.intranet.d.dao;

import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.result.ResultSetReader;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.datasource.Ydb;
import ru.yandex.intranet.d.datasource.model.YdbTxSession;

/**
 * Readiness YDB check
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class ReadinessDao {
    public static final String TEST_QUERY = "SELECT CAST('OK' AS Utf8) AS status;";

    public Mono<StatusWithMessage> ping(YdbTxSession session) {
        return session.executeDataQueryRetryable(TEST_QUERY)
                .map(this::toStatusWithMessage);

    }

    private StatusWithMessage toStatusWithMessage(DataQueryResult result) {
        if (result.isEmpty()) {
            throw new IllegalStateException("No answer");
        }
        if (result.getResultSetCount() > 1) {
            throw new IllegalStateException("Too many result sets");
        }
        ResultSetReader reader = result.getResultSet(0);
        if (!reader.next()) {
            throw new IllegalStateException("Emtpy answer");
        }
        if (reader.getRowCount() > 1) {
            throw new IllegalStateException("Too many rows");
        }

        return StatusWithMessage.statusWithMessage(Status.valueOf(Ydb.utf8OrNull(reader.getColumn("status"))), null);
    }

    public static class StatusWithMessage {
        private final Status status;
        private final String message;

        public StatusWithMessage(Status status, String message) {
            this.status = status;
            this.message = message;
        }

        public Status getStatus() {
            return status;
        }

        public String getMessage() {
            return message;
        }

        public static StatusWithMessage statusWithMessage(Status status, String message) {
            return new StatusWithMessage(status, message);
        }

        @Override
        public String toString() {
            return "StatusWithMessage{" +
                    "status=" + status +
                    ", message='" + message + '\'' +
                    '}';
        }
    }

    public enum Status {
        OK,
        ERROR,
    }
}
