package ru.yandex.intranet.d.dao;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.model.users.UserModel;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Tenants constants.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Tenants {
    private static final String DEFAULT_TENANT_ID_STRING = "7c8749f6-92f2-4bd3-82b9-6ed98125d517";
    public static final TenantId DEFAULT_TENANT_ID = new TenantId(DEFAULT_TENANT_ID_STRING);

    private Tenants() {
    }

    public static TenantId getInstance(String id) {
        //noinspection SwitchStatementWithTooFewBranches
        switch (id) {
            case DEFAULT_TENANT_ID_STRING:
                return DEFAULT_TENANT_ID;
            default:
                return new TenantId(id);
        }
    }

    public static TenantId getTenantId(YaUserDetails currentUser) {
        if (currentUser == null) {
            return DEFAULT_TENANT_ID;
        }
        return currentUser.getUser().map(UserModel::getTenantId)
                .or(() -> currentUser.getProviders().stream().findFirst().map(ProviderModel::getTenantId))
                .orElse(DEFAULT_TENANT_ID);
    }

    public static <T> List<Tuple2<T, TenantId>> withTenantId(Collection<T> data, TenantId tenantId) {
        return data.stream().map(t -> Tuples.of(t, tenantId)).collect(Collectors.toList());
    }
}
