package ru.yandex.intranet.d.dao.accounts;

import java.util.Objects;
import java.util.Optional;

/**
 * Position for accounts by folder and provider paging.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountByFolderAndProviderPagingFrom {

    private final String accountsSpaceId;
    private final String accountId;

    public AccountByFolderAndProviderPagingFrom(String accountsSpaceId, String accountId) {
        this.accountsSpaceId = accountsSpaceId;
        this.accountId = accountId;
    }

    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountByFolderAndProviderPagingFrom that = (AccountByFolderAndProviderPagingFrom) o;
        return Objects.equals(accountsSpaceId, that.accountsSpaceId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountsSpaceId, accountId);
    }

    @Override
    public String toString() {
        return "AccountByFolderAndProviderPagingFrom{" +
                "accountsSpaceId='" + accountsSpaceId + '\'' +
                ", accountId='" + accountId + '\'' +
                '}';
    }

}
