package ru.yandex.intranet.d.dao.accounts;

import java.util.Objects;
import java.util.Optional;

/**
 * Position for accounts by folder paging.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class AccountByFolderPagingFrom {

    private final String providerId;
    private final String accountsSpaceId;
    private final String accountId;

    public AccountByFolderPagingFrom(String providerId, String accountsSpaceId, String accountId) {
        this.providerId = providerId;
        this.accountsSpaceId = accountsSpaceId;
        this.accountId = accountId;
    }

    public String getProviderId() {
        return providerId;
    }

    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountByFolderPagingFrom that = (AccountByFolderPagingFrom) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(accountsSpaceId, that.accountsSpaceId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, accountsSpaceId, accountId);
    }

    @Override
    public String toString() {
        return "AccountByFolderPagingFrom{" +
                "providerId='" + providerId + '\'' +
                ", accountsSpaceId='" + accountsSpaceId + '\'' +
                ", accountId='" + accountId + '\'' +
                '}';
    }

}
