package ru.yandex.intranet.d.dao.folders;

import java.io.UncheckedIOException;
import java.util.Optional;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.OptionalValue;
import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.PrimitiveValue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.folders.AccountsHistoryModel;
import ru.yandex.intranet.d.util.ObjectMapperHolder;

/**
 * Accounts history helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class AccountsHistoryHelper {

    private final ObjectReader accountsHistoryReader;
    private final ObjectWriter accountsHistoryWriter;

    public AccountsHistoryHelper(@Qualifier("ydbJsonObjectMapper") ObjectMapperHolder objectMapper) {
        this.accountsHistoryReader = objectMapper.getObjectMapper().readerFor(AccountsHistoryModel.class);
        this.accountsHistoryWriter = objectMapper.getObjectMapper().writerFor(AccountsHistoryModel.class);
    }

    public Optional<AccountsHistoryModel> readAccountsHistory(ValueReader reader) {
        if (reader.isOptionalItemPresent()) {
            try {
                return Optional.ofNullable(accountsHistoryReader.readValue(reader.getJsonDocument()));
            } catch (JsonProcessingException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            return Optional.empty();
        }
    }

    public OptionalValue writeAccountsHistory(AccountsHistoryModel value) {
        OptionalType type = OptionalType.of(PrimitiveType.jsonDocument());
        if (value != null) {
            try {
                return type.newValue(PrimitiveValue.jsonDocument(accountsHistoryWriter.writeValueAsString(value)));
            } catch (JsonProcessingException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            return type.emptyValue();
        }
    }

}
