package ru.yandex.intranet.d.dao.folders;

import java.io.UncheckedIOException;
import java.util.Optional;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.OptionalValue;
import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.PrimitiveValue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.folders.FolderHistoryFieldsModel;
import ru.yandex.intranet.d.util.ObjectMapperHolder;

/**
 * Folder history fields helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class FolderHistoryFieldsHelper {

    private final ObjectReader historyFieldsReader;
    private final ObjectWriter historyFieldsWriter;

    public FolderHistoryFieldsHelper(@Qualifier("ydbJsonObjectMapper") ObjectMapperHolder objectMapper) {
        this.historyFieldsReader = objectMapper.getObjectMapper().readerFor(FolderHistoryFieldsModel.class);
        this.historyFieldsWriter = objectMapper.getObjectMapper().writerFor(FolderHistoryFieldsModel.class);
    }

    public Optional<FolderHistoryFieldsModel> readFolderHistoryFields(ValueReader reader) {
        if (reader.isOptionalItemPresent()) {
            try {
                return Optional.ofNullable(historyFieldsReader.readValue(reader.getJsonDocument()));
            } catch (JsonProcessingException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            return Optional.empty();
        }
    }

    public OptionalValue writeFolderHistoryFields(FolderHistoryFieldsModel value) {
        OptionalType type = OptionalType.of(PrimitiveType.jsonDocument());
        if (value != null) {
            try {
                return type.newValue(PrimitiveValue.jsonDocument(historyFieldsWriter.writeValueAsString(value)));
            } catch (JsonProcessingException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            return type.emptyValue();
        }
    }

}
