package ru.yandex.intranet.d.dao.folders;

import java.util.HashMap;
import java.util.Map;

import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.Value;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.dao.AbstractDao;
import ru.yandex.intranet.d.datasource.impl.YdbQuerySource;
import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.WithTenant;
import ru.yandex.intranet.d.model.folders.FolderOperationLogCommentModel;

/**
 * FolderOperationLogCommentDao
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Component
public class FolderOperationLogCommentDao extends AbstractDao<FolderOperationLogCommentModel, String> {

    public FolderOperationLogCommentDao(YdbQuerySource ydbQuerySource) {
        super(ydbQuerySource);
    }

    @Override
    protected WithTenant<String> getIdentityWithTenant(FolderOperationLogCommentModel model) {
        return new WithTenant<>(model.getTenantId(), model.getId());
    }

    @Override
    protected Params getIdentityParams(String id) {
        return Params.create()
                .put("$id", PrimitiveValue.utf8(id));
    }

    @Override
    protected Map<String, Value> prepareFieldValues(FolderOperationLogCommentModel model) {
        HashMap<String, Value> fields = new HashMap<>();
        fields.put(Fields.ID.field(), PrimitiveValue.utf8(model.getId()));
        fields.put(Fields.TENANT_ID.field(), PrimitiveValue.utf8(model.getTenantId().getId()));
        fields.put(Fields.CREATED_AT.field(), PrimitiveValue.timestamp(model.getCreatedAt()));
        fields.put(Fields.CREATED_BY.field(), PrimitiveValue.utf8(model.getCreatedBy()));
        fields.put(Fields.TEXT.field(), PrimitiveValue.utf8(model.getText()));
        return fields;
    }

    @Override
    protected FolderOperationLogCommentModel readOneRow(ResultSetReader reader, Map<String, TenantId> tenantIdCache) {
        return FolderOperationLogCommentModel.builder()
                .setId(reader.getColumn(Fields.ID.field()).getUtf8())
                .setTenantId(tenantIdCache.computeIfAbsent(reader
                        .getColumn(Fields.TENANT_ID.field()).getUtf8(), TenantId::new))
                .setCreatedAt(reader.getColumn(Fields.CREATED_AT.field()).getTimestamp())
                .setCreatedBy(reader.getColumn(Fields.CREATED_BY.field()).getUtf8())
                .setText(reader.getColumn(Fields.TEXT.field()).getUtf8())
                .build();
    }

    @Override
    protected String queryKeyPrefix() {
        return "yql.queries.folderOperationLogComment";
    }

    public enum Fields {

        ID,
        TENANT_ID,
        CREATED_AT,
        CREATED_BY,
        TEXT;

        public String field() {
            return name().toLowerCase();
        }
    }
}
