package ru.yandex.intranet.d.dao.folders;

import java.io.UncheckedIOException;
import java.util.Set;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.PrimitiveValue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.util.ObjectMapperHolder;

/**
 * Write / read folder tags JSON.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 26.10.2020
 */
@Component
public class FolderTagsHelper {
    private final ObjectReader tagsReader;
    private final ObjectWriter tagsWriter;

    public FolderTagsHelper(
            @Qualifier("ydbJsonObjectMapper") ObjectMapperHolder objectMapper
    ) {
        ObjectMapper mapper = objectMapper.getObjectMapper();
        TypeReference<Set<String>> tagsTypeReference = new TypeReference<>() {
        };
        this.tagsReader = mapper.readerFor(tagsTypeReference);
        this.tagsWriter = mapper.writerFor(tagsTypeReference);
    }

    public Set<String> readTags(ValueReader reader) {
        String json = reader.getJsonDocument();
        try {
            return tagsReader.readValue(json);
        } catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PrimitiveValue writeTags(Set<String> tags) {
        try {
            String json = tagsWriter.writeValueAsString(tags);
            return PrimitiveValue.jsonDocument(json);
        } catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }
}
