package ru.yandex.intranet.d.datasource;

import java.time.Duration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.intranet.d.datasource.coordination.ClusterManager;
import ru.yandex.intranet.d.datasource.coordination.CoordinationClient;
import ru.yandex.intranet.d.datasource.coordination.Coordinator;
import ru.yandex.intranet.d.datasource.coordination.rpc.CoordinationRpc;
import ru.yandex.intranet.d.datasource.coordination.rpc.grpc.GrpcCoordinationRpc;
import ru.yandex.intranet.d.datasource.coordination.spring.AutoClusterManager;
import ru.yandex.intranet.d.datasource.impl.YdbRpcTransport;

/**
 * YDB coordination configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Configuration
public class YdbCoordinationConfiguration {

    @Bean
    public CoordinationRpc ydbCoordinationRpc(YdbRpcTransport rpcTransport) {
        return GrpcCoordinationRpc.useTransport(rpcTransport.getRpcTransport());
    }

    @Bean
    public CoordinationClient ydbCoordinationClient(CoordinationRpc coordinationRpc) {
        return CoordinationClient.newClient(coordinationRpc).build();
    }

    @Bean
    public AutoClusterManager ydbClusterManager(
            CoordinationClient coordinationClient,
            @Value("${ydb.tablePathPrefix}") String tablePathPrefix,
            @Value("${ydb.coordination.nodeName}") String nodeName,
            @Value("${ydb.coordination.leadershipSemaphoreName}") String leadershipSemaphoreName,
            @Value("${ydb.coordination.membershipSemaphoreName}") String membershipSemaphoreName,
            @Value("${ydb.coordination.schedulerShutdownTimeoutMs}") long schedulerShutdownTimeoutMs) {
        Coordinator.Builder coordinator = Coordinator.newCoordinator(coordinationClient,
                tablePathPrefix + "/" + nodeName)
                .schedulerShutdownTimeout(Duration.ofMillis(schedulerShutdownTimeoutMs));
        ClusterManager clusterManager = ClusterManager.newClusterManager(leadershipSemaphoreName,
                membershipSemaphoreName, coordinator).build();
        return new AutoClusterManager(clusterManager);
    }

}
