package ru.yandex.intranet.d.datasource.coordination.impl;

import ru.yandex.intranet.d.datasource.coordination.VersionSupplier;
import ru.yandex.library.svnversion.VcsVersion;

/**
 * Version supplier.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ArcadiaVersionSupplier implements VersionSupplier {

    @Override
    public String getVersion() {
        VcsVersion version = new VcsVersion(ArcadiaVersionSupplier.class);
        int svnRevision = version.getProgramSvnRevision();
        if (svnRevision < 0) {
            String programHash = version.getProgramHash();
            if (programHash.isEmpty()) {
                return "current";
            }
            return programHash;
        }
        return String.valueOf(svnRevision);
    }

}
