package ru.yandex.intranet.d.datasource.coordination.impl;

import ru.yandex.intranet.d.datasource.coordination.CoordinationClient;
import ru.yandex.intranet.d.datasource.coordination.rpc.CoordinationRpc;

/**
 * YDB coordination client builder.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class CoordinationClientBuilderImpl implements CoordinationClient.Builder {

    private final CoordinationRpc coordinationRpc;

    public CoordinationClientBuilderImpl(CoordinationRpc coordinationRpc) {
        this.coordinationRpc = coordinationRpc;
    }

    @Override
    public CoordinationClient build() {
        return new CoordinationClientImpl(coordinationRpc);
    }

}
