package ru.yandex.intranet.d.datasource.coordination.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

/**
 * Deploy host info utils.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeployHostInfoUtils {

    private static final Logger LOG = LoggerFactory.getLogger(DeployHostInfoUtils.class);

    private static final Pattern IP_KEY_PATTERN = Pattern.compile("^DEPLOY_POD_IP_(\\d{1,6})_ADDRESS$");

    private DeployHostInfoUtils() {
    }

    public static String getPersistentFqdn() {
        String deployFqdn = System.getenv("DEPLOY_POD_PERSISTENT_FQDN");
        if (deployFqdn != null) {
            return deployFqdn;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        } catch (Exception e) {
            LOG.warn("Failed to get host name", e);
            return "";
        }
    }

    public static String getTransientFqdn() {
        String deployFqdn = System.getenv("DEPLOY_POD_TRANSIENT_FQDN");
        if (deployFqdn != null) {
            return deployFqdn;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        } catch (Exception e) {
            LOG.warn("Failed to get host name", e);
            return "";
        }
    }

    public static List<String> getHostIps() {
        Map<String, String> env = System.getenv();
        List<Tuple2<Long, String>> addresses = new ArrayList<>();
        env.forEach((k, v) -> {
            Matcher matcher = IP_KEY_PATTERN.matcher(k);
            if (matcher.find()) {
                addresses.add(Tuples.of(Long.valueOf(matcher.group(1)), v));
            }
        });
        List<String> result = addresses.stream().sorted(Comparator.comparing(Tuple2::getT1))
                .map(Tuple2::getT2).collect(Collectors.toList());
        if (!result.isEmpty()) {
            return result;
        }
        try {
            return List.of(InetAddress.getLocalHost().getHostAddress());
        } catch (Exception e) {
            LOG.warn("Failed to get host address", e);
            return List.of();
        }
    }

}
