package ru.yandex.intranet.d.datasource.coordination.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.intranet.d.datasource.coordination.model.cluster.ClusterLeader;

/**
 * Leader publisher.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class LeaderPublisher {

    private static final Logger LOG = LoggerFactory.getLogger(LeaderPublisher.class);

    private final AtomicReference<ClusterLeader> clusterLeader
            = new AtomicReference<>(new ClusterLeader(null, false));
    private final ConcurrentLinkedQueue<Consumer<ClusterLeader>> subscribers = new ConcurrentLinkedQueue<>();

    public ClusterLeader getClusterLeader() {
        return clusterLeader.get();
    }

    public void addSubscriber(Consumer<ClusterLeader> consumer) {
        subscribers.add(consumer);
    }

    public void nextLeader(ClusterLeader newClusterLeader) {
        ClusterLeader oldLeader = this.clusterLeader.getAndSet(newClusterLeader);
        if (!newClusterLeader.equals(oldLeader)) {
            subscribers.forEach(s -> s.accept(newClusterLeader));
            LOG.info("New leader: {}", newClusterLeader);
        }
    }

    public void complete() {
        ClusterLeader newValue = new ClusterLeader(null, false);
        ClusterLeader oldLeader = this.clusterLeader.getAndSet(newValue);
        if (!newValue.equals(oldLeader)) {
            subscribers.forEach(s -> s.accept(newValue));
            LOG.info("New leader: {}", newValue);
        }
    }

    public void error(Throwable e) {
        ClusterLeader newValue = new ClusterLeader(null, false);
        ClusterLeader oldLeader = this.clusterLeader.getAndSet(newValue);
        if (!newValue.equals(oldLeader)) {
            subscribers.forEach(s -> s.accept(newValue));
            LOG.info("New leader: {}", newValue);
        }
    }

}
