package ru.yandex.intranet.d.datasource.coordination.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.intranet.d.datasource.coordination.model.cluster.NodeLeadershipStatus;

/**
 * Leadership publisher.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class LeadershipPublisher {

    private static final Logger LOG = LoggerFactory.getLogger(LeadershipPublisher.class);

    private final AtomicReference<NodeLeadershipStatus> leadershipStatus
            = new AtomicReference<>(NodeLeadershipStatus.UNDEFINED);
    private final ConcurrentLinkedQueue<Consumer<NodeLeadershipStatus>> subscribers = new ConcurrentLinkedQueue<>();

    public NodeLeadershipStatus getLeadershipStatus() {
        return leadershipStatus.get();
    }

    public void addSubscriber(Consumer<NodeLeadershipStatus> consumer) {
        subscribers.add(consumer);
    }

    public void nextStatus(NodeLeadershipStatus status) {
        NodeLeadershipStatus oldStatus = leadershipStatus.getAndSet(status);
        if (status != oldStatus) {
            subscribers.forEach(s -> s.accept(status));
            LOG.info("New leadership status: {}", status);
        }
    }

    public void complete() {
        NodeLeadershipStatus oldStatus = leadershipStatus.getAndSet(NodeLeadershipStatus.UNDEFINED);
        if (oldStatus != NodeLeadershipStatus.UNDEFINED) {
            subscribers.forEach(s -> s.accept(NodeLeadershipStatus.UNDEFINED));
            LOG.info("New leadership status: {}", NodeLeadershipStatus.UNDEFINED);
        }
    }

    public void error(Throwable e) {
        NodeLeadershipStatus oldStatus = leadershipStatus.getAndSet(NodeLeadershipStatus.UNDEFINED);
        if (oldStatus != NodeLeadershipStatus.UNDEFINED) {
            subscribers.forEach(s -> s.accept(NodeLeadershipStatus.UNDEFINED));
            LOG.info("New leadership status: {}", NodeLeadershipStatus.UNDEFINED);
        }
    }

}
