package ru.yandex.intranet.d.datasource.coordination.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.intranet.d.datasource.coordination.model.cluster.ClusterMembership;
import ru.yandex.intranet.d.datasource.coordination.model.cluster.NodeInfo;

/**
 * Leadership publisher.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class MembershipPublisher {

    private static final Logger LOG = LoggerFactory.getLogger(MembershipPublisher.class);

    private final AtomicReference<ClusterMembership> clusterMembership
            = new AtomicReference<>(new ClusterMembership(Set.of(), false));
    private final AtomicReference<ClusterMembership> lastSeenClusterMembers
            = new AtomicReference<>(new ClusterMembership(Set.of(), false));
    private final ConcurrentLinkedQueue<Consumer<ClusterMembership>> subscribers = new ConcurrentLinkedQueue<>();

    public ClusterMembership getClusterMembership() {
        return clusterMembership.get();
    }

    public Set<NodeInfo> getLastSeenClusterMembers() {
        ClusterMembership current = lastSeenClusterMembers.get();
        if (current.isConnected()) {
            return current.getClusterMembers();
        }
        return Set.of();
    }

    public void addSubscriber(Consumer<ClusterMembership> consumer) {
        subscribers.add(consumer);
    }

    public void nextMembership(ClusterMembership newClusterMembership) {
        ClusterMembership oldMembership = this.clusterMembership.getAndSet(newClusterMembership);
        if (!newClusterMembership.equals(oldMembership)) {
            subscribers.forEach(s -> s.accept(newClusterMembership));
            if (newClusterMembership.isConnected()) {
                lastSeenClusterMembers.set(newClusterMembership);
            }
            LOG.info("New cluster membership: {}", newClusterMembership);
        }
    }

    public void complete() {
        ClusterMembership newValue = new ClusterMembership(Set.of(), false);
        ClusterMembership oldMembership = this.clusterMembership.getAndSet(newValue);
        if (!newValue.equals(oldMembership)) {
            subscribers.forEach(s -> s.accept(newValue));
            LOG.info("New cluster membership: {}", newValue);
        }
    }

    public void error(Throwable e) {
        ClusterMembership newValue = new ClusterMembership(Set.of(), false);
        ClusterMembership oldMembership = this.clusterMembership.getAndSet(newValue);
        if (!newValue.equals(oldMembership)) {
            subscribers.forEach(s -> s.accept(newValue));
            LOG.info("New cluster membership: {}", newValue);
        }
    }

}
