package ru.yandex.intranet.d.datasource.coordination.metrics;

import java.util.Set;

import javax.annotation.PostConstruct;

import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.datasource.coordination.model.session.SessionState;
import ru.yandex.intranet.d.datasource.coordination.spring.AutoClusterManager;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Coordination metrics.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class CoordinationMetrics {

    private final AutoClusterManager clusterManager;
    private final MetricRegistry metricRegistry;

    public CoordinationMetrics(AutoClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        this.metricRegistry = MetricRegistry.root();
    }

    @PostConstruct
    public void postConstruct() {
        metricRegistry.lazyGaugeInt64("coord.session.active",
                () -> clusterManager.getSessionState() == SessionState.VALID ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("coord.is.leader",
                () -> clusterManager.isLeaderCached().orElse(false) ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("coord.is.follower",
                () -> clusterManager.isLeaderCached().map(v -> !v).orElse(false) ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("coord.has.leader",
                () -> clusterManager.getLeaderCached().isPresent() ? 1L : 0L);
        metricRegistry.lazyGaugeInt64("coord.members.count",
                () -> clusterManager.getMembersCached().map(Set::size).orElse(0));
        metricRegistry.lazyGaugeInt64("coord.is.member",
                () -> clusterManager.isMemberCached().orElse(false) ? 1L : 0L);
        String currentVersion = clusterManager.getCurrentVersion();
        metricRegistry.lazyGaugeInt64("coord.members.with.same.version",
                () -> clusterManager.getMembersCached().map(s -> s.stream()
                        .filter(n -> currentVersion.equals(n.getVersion())).count()).orElse(0L));
    }

}
