package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.Objects;

/**
 * Coordination node.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CoordinationNode {

    private final String path;

    public CoordinationNode(String path) {
        this.path = path;
    }

    public String getPath() {
        return path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CoordinationNode that = (CoordinationNode) o;
        return Objects.equals(path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path);
    }

    @Override
    public String toString() {
        return "CoordinationNode{" +
                "path='" + path + '\'' +
                '}';
    }

}
