package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.Objects;

/**
 * Coordination node description.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CoordinationNodeDescription {

    private final SchemeEntry self;
    private final NodeConfig configuration;

    public CoordinationNodeDescription(SchemeEntry self, NodeConfig configuration) {
        this.self = self;
        this.configuration = configuration;
    }

    public SchemeEntry getSelf() {
        return self;
    }

    public NodeConfig getConfiguration() {
        return configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CoordinationNodeDescription that = (CoordinationNodeDescription) o;
        return Objects.equals(self, that.self) &&
                Objects.equals(configuration, that.configuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, configuration);
    }

    @Override
    public String toString() {
        return "CoordinationNodeDescription{" +
                "self=" + self +
                ", configuration=" + configuration +
                '}';
    }

}
