package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Create node request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateCoordinationNodeRequest {

    private final String path;
    private final TargetNodeConfig configuration;
    private final OperationParameters operationParameters;

    private CreateCoordinationNodeRequest(String path, TargetNodeConfig configuration,
                                          OperationParameters operationParameters) {
        this.path = path;
        this.configuration = configuration;
        this.operationParameters = operationParameters;
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    public String getPath() {
        return path;
    }

    public Optional<TargetNodeConfig> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public Optional<OperationParameters> getOperationParameters() {
        return Optional.ofNullable(operationParameters);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateCoordinationNodeRequest that = (CreateCoordinationNodeRequest) o;
        return Objects.equals(path, that.path) &&
                Objects.equals(configuration, that.configuration) &&
                Objects.equals(operationParameters, that.operationParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path, configuration, operationParameters);
    }

    @Override
    public String toString() {
        return "CreateCoordinationNodeRequest{" +
                "path='" + path + '\'' +
                ", configuration=" + configuration +
                ", operationParameters=" + operationParameters +
                '}';
    }

    public static final class Builder {

        private final String path;

        private TargetNodeConfig configuration;
        private OperationParameters operationParameters = OperationParameters.builder().build();

        private Builder(String path) {
            this.path = path;
        }

        public Builder configuration(TargetNodeConfig configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder operationParameters(OperationParameters operationParameters) {
            this.operationParameters = operationParameters;
            return this;
        }

        public CreateCoordinationNodeRequest build() {
            return new CreateCoordinationNodeRequest(path, configuration, operationParameters);
        }

    }

}
