package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Drop node request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DropCoordinationNodeRequest {

    private final String path;
    private final OperationParameters operationParameters;

    private DropCoordinationNodeRequest(String path, OperationParameters operationParameters) {
        this.path = path;
        this.operationParameters = operationParameters;
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    public String getPath() {
        return path;
    }

    public Optional<OperationParameters> getOperationParameters() {
        return Optional.ofNullable(operationParameters);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DropCoordinationNodeRequest that = (DropCoordinationNodeRequest) o;
        return Objects.equals(path, that.path) &&
                Objects.equals(operationParameters, that.operationParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path, operationParameters);
    }

    @Override
    public String toString() {
        return "DropCoordinationNodeRequest{" +
                "path='" + path + '\'' +
                ", operationParameters=" + operationParameters +
                '}';
    }

    public static final class Builder {

        private final String path;

        private OperationParameters operationParameters = OperationParameters.builder().build();

        private Builder(String path) {
            this.path = path;
        }

        public Builder operationParameters(OperationParameters operationParameters) {
            this.operationParameters = operationParameters;
            return this;
        }

        public DropCoordinationNodeRequest builder() {
            return new DropCoordinationNodeRequest(path, operationParameters);
        }

    }

}
