package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.List;
import java.util.Objects;

/**
 * Scheme entry.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SchemeEntry {

    private final String name;
    private final String owner;
    private final SchemeEntryType type;
    private final List<SchemeEntryPermission> effectivePermissions;
    private final List<SchemeEntryPermission> permissions;

    public SchemeEntry(String name, String owner, SchemeEntryType type,
                       List<SchemeEntryPermission> effectivePermissions, List<SchemeEntryPermission> permissions) {
        this.name = name;
        this.owner = owner;
        this.type = type;
        this.effectivePermissions = effectivePermissions;
        this.permissions = permissions;
    }

    /**
     * Get a name of scheme entry.
     * @return Name of scheme entry.
     */
    public String getName() {
        return name;
    }

    /**
     * Get a SID (Security ID) of user or group.
     * @return SID (Security ID) of user or group.
     */
    public String getOwner() {
        return owner;
    }

    public SchemeEntryType getType() {
        return type;
    }

    public List<SchemeEntryPermission> getEffectivePermissions() {
        return effectivePermissions;
    }

    public List<SchemeEntryPermission> getPermissions() {
        return permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchemeEntry that = (SchemeEntry) o;
        return Objects.equals(name, that.name) &&
                Objects.equals(owner, that.owner) &&
                type == that.type &&
                Objects.equals(effectivePermissions, that.effectivePermissions) &&
                Objects.equals(permissions, that.permissions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, owner, type, effectivePermissions, permissions);
    }

    @Override
    public String toString() {
        return "SchemeEntry{" +
                "name='" + name + '\'' +
                ", owner='" + owner + '\'' +
                ", type=" + type +
                ", effectivePermissions=" + effectivePermissions +
                ", permissions=" + permissions +
                '}';
    }

}
