package ru.yandex.intranet.d.datasource.coordination.model;

import java.util.List;
import java.util.Objects;

/**
 * Scheme entry permission.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SchemeEntryPermission {

    private final String subject;
    private final List<String> permissionNames;

    public SchemeEntryPermission(String subject, List<String> permissionNames) {
        this.subject = subject;
        this.permissionNames = permissionNames;
    }

    /**
     * Get a SID (Security ID) of user or group.
     * @return SID (Security ID) of user or group.
     */
    public String getSubject() {
        return subject;
    }

    public List<String> getPermissionNames() {
        return permissionNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchemeEntryPermission that = (SchemeEntryPermission) o;
        return Objects.equals(subject, that.subject) &&
                Objects.equals(permissionNames, that.permissionNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(subject, permissionNames);
    }

    @Override
    public String toString() {
        return "SchemeEntryPermission{" +
                "subject='" + subject + '\'' +
                ", permissionNames=" + permissionNames +
                '}';
    }

}
