package ru.yandex.intranet.d.datasource.coordination.model.cluster;

import java.util.Objects;
import java.util.Optional;

/**
 * Cluster leader.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ClusterLeader {

    private final NodeInfo leader;
    private final boolean connected;

    public ClusterLeader(NodeInfo leader, boolean connected) {
        this.leader = leader;
        this.connected = connected;
    }

    public Optional<NodeInfo> getLeader() {
        return Optional.ofNullable(leader);
    }

    public boolean isConnected() {
        return connected;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterLeader that = (ClusterLeader) o;
        return connected == that.connected &&
                Objects.equals(leader, that.leader);
    }

    @Override
    public int hashCode() {
        return Objects.hash(leader, connected);
    }

    @Override
    public String toString() {
        return "ClusterLeader{" +
                "leader=" + leader +
                ", connected=" + connected +
                '}';
    }

}
