package ru.yandex.intranet.d.datasource.coordination.model.cluster;

import java.util.Objects;
import java.util.Set;

/**
 * Cluster membership.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ClusterMembership {

    private final Set<NodeInfo> clusterMembers;
    private final boolean connected;

    public ClusterMembership(Set<NodeInfo> clusterMembers, boolean connected) {
        this.clusterMembers = clusterMembers;
        this.connected = connected;
    }

    public Set<NodeInfo> getClusterMembers() {
        return clusterMembers;
    }

    public boolean isConnected() {
        return connected;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterMembership that = (ClusterMembership) o;
        return connected == that.connected &&
                Objects.equals(clusterMembers, that.clusterMembers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clusterMembers, connected);
    }

    @Override
    public String toString() {
        return "ClusterMembership{" +
                "clusterMembers=" + clusterMembers +
                ", connected=" + connected +
                '}';
    }

}
