package ru.yandex.intranet.d.datasource.coordination.model.cluster;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cluster node info.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class NodeInfo {

    private final String uuid;
    private final String transientFqdn;
    private final String persistentFqdn;
    private final List<String> hostIps;
    private final String version;

    @JsonCreator
    public NodeInfo(
            @JsonProperty("uuid") String uuid,
            @JsonProperty("transientFqdn") String transientFqdn,
            @JsonProperty("persistentFqdn") String persistentFqdn,
            @JsonProperty("hostIps") List<String> hostIps,
            @JsonProperty("version") String version) {
        this.uuid = uuid;
        this.transientFqdn = transientFqdn;
        this.persistentFqdn = persistentFqdn;
        this.hostIps = hostIps;
        this.version = version;
    }

    public String getUuid() {
        return uuid;
    }

    public String getTransientFqdn() {
        return transientFqdn;
    }

    public String getPersistentFqdn() {
        return persistentFqdn;
    }

    public List<String> getHostIps() {
        return hostIps;
    }

    public String getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo) o;
        return Objects.equals(uuid, nodeInfo.uuid) &&
                Objects.equals(transientFqdn, nodeInfo.transientFqdn) &&
                Objects.equals(persistentFqdn, nodeInfo.persistentFqdn) &&
                Objects.equals(hostIps, nodeInfo.hostIps) &&
                Objects.equals(version, nodeInfo.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uuid, transientFqdn, persistentFqdn, hostIps, version);
    }

    @Override
    public String toString() {
        return "NodeInfo{" +
                "uuid='" + uuid + '\'' +
                ", transientFqdn='" + transientFqdn + '\'' +
                ", persistentFqdn='" + persistentFqdn + '\'' +
                ", hostIps=" + hostIps +
                ", version='" + version + '\'' +
                '}';
    }

}
