package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Acquire semaphore pending response. Used by the server to report when an acquire operation
 * is added to the waiters queue.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AcquireSemaphorePendingResponse {

    private final long reqId;

    public AcquireSemaphorePendingResponse(long reqId) {
        this.reqId = reqId;
    }

    public long getReqId() {
        return reqId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AcquireSemaphorePendingResponse that = (AcquireSemaphorePendingResponse) o;
        return reqId == that.reqId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId);
    }

    @Override
    public String toString() {
        return "AcquireSemaphorePendingResponse{" +
                "reqId=" + reqId +
                '}';
    }

}
