package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import com.yandex.ydb.core.Status;

/**
 * Acquire semaphore result response. Used by the server to report the result of an acquire operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AcquireSemaphoreResultResponse {

    private final long reqId;
    private final Status status;
    private final boolean acquired;

    public AcquireSemaphoreResultResponse(long reqId, Status status, boolean acquired) {
        this.reqId = reqId;
        this.status = status;
        this.acquired = acquired;
    }

    public long getReqId() {
        return reqId;
    }

    public Status getStatus() {
        return status;
    }

    /**
     * Returns true if semaphore was acquired, false if acquire timed out.
     * @return True if semaphore was acquired, false if acquire timed out.
     */
    public boolean isAcquired() {
        return acquired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AcquireSemaphoreResultResponse that = (AcquireSemaphoreResultResponse) o;
        return reqId == that.reqId &&
                acquired == that.acquired &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reqId, status, acquired);
    }

    @Override
    public String toString() {
        return "AcquireSemaphoreResultResponse{" +
                "reqId=" + reqId +
                ", status=" + status +
                ", acquired=" + acquired +
                '}';
    }

}
