package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

import reactor.core.publisher.Mono;

/**
 * Changes subscription.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ChangesSubscription {

    private final Mono<SemaphoreEvent> subscription;
    private final CoordinationSemaphoreDescription description;
    private final Runnable onCancel;

    public ChangesSubscription(Mono<SemaphoreEvent> subscription, CoordinationSemaphoreDescription description,
                               Runnable onCancel) {
        this.subscription = subscription;
        this.description = description;
        this.onCancel = onCancel;
    }

    public Mono<SemaphoreEvent> getSubscription() {
        return subscription;
    }

    public CoordinationSemaphoreDescription getDescription() {
        return description;
    }

    public void cancel() {
        onCancel.run();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangesSubscription that = (ChangesSubscription) o;
        return Objects.equals(subscription, that.subscription) &&
                Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscription, description);
    }

    @Override
    public String toString() {
        return "ChangesSubscription{" +
                "subscription=" + subscription +
                ", description=" + description +
                '}';
    }

}
