package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Coordination semaphore.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CoordinationSemaphore {

    private final String name;

    public CoordinationSemaphore(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CoordinationSemaphore that = (CoordinationSemaphore) o;
        return Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    @Override
    public String toString() {
        return "CoordinationSemaphore{" +
                "name='" + name + '\'' +
                '}';
    }

}
