package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Session request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface CoordinationSessionRequest {

    static CoordinationSessionRequest ping(PingPongRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.ping(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::ping{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest pong(PingPongRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.pong(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::pong{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest sessionStart(SessionStartRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.sessionStart(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::sessionStart{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest sessionStop(SessionStopRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.sessionStop(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::sessionStop{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest acquireSemaphore(AcquireSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.acquireSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::acquireSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest releaseSemaphore(ReleaseSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.releaseSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::releaseSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest describeSemaphore(DescribeSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.describeSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::describeSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest createSemaphore(CreateSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.createSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::createSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest updateSemaphore(UpdateSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.updateSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::updateSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    static CoordinationSessionRequest deleteSemaphore(DeleteSemaphoreRequest request) {
        return new CoordinationSessionRequest() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.deleteSemaphore(request);
            }
            @Override
            public int hashCode() {
                return Objects.hash(request);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionRequest)) {
                    return false;
                }
                CoordinationSessionRequest sessionRequest = (CoordinationSessionRequest) obj;
                return sessionRequest.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStart(SessionStartRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStop(SessionStopRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphore(AcquireSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphore(ReleaseSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphore(DescribeSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphore(CreateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphore(UpdateSemaphoreRequest otherRequest) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphore(DeleteSemaphoreRequest otherRequest) {
                        return Objects.equals(request, otherRequest);
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionRequest::deleteSemaphore{"
                        + "request=" + request
                        + '}';
            }
        };
    }

    <R> R match(Cases<R> cases);

    interface Cases<O> {

        O ping(PingPongRequest request);

        O pong(PingPongRequest request);

        O sessionStart(SessionStartRequest request);

        O sessionStop(SessionStopRequest request);

        O acquireSemaphore(AcquireSemaphoreRequest request);

        O releaseSemaphore(ReleaseSemaphoreRequest request);

        O describeSemaphore(DescribeSemaphoreRequest request);

        O createSemaphore(CreateSemaphoreRequest request);

        O updateSemaphore(UpdateSemaphoreRequest request);

        O deleteSemaphore(DeleteSemaphoreRequest request);
    }

}
