package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Objects;

/**
 * Session response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface CoordinationSessionResponse {

    static CoordinationSessionResponse ping(PingPongResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.ping(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::ping{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse pong(PingPongResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.pong(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::pong{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse failure(FailureResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.failure(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::failure{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse sessionStarted(SessionStartedResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.sessionStarted(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::sessionStarted{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse sessionStopped(SessionStoppedResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.sessionStopped(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::sessionStopped{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse acquireSemaphorePending(AcquireSemaphorePendingResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.acquireSemaphorePending(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::acquireSemaphorePending{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse acquireSemaphoreResult(AcquireSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.acquireSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::acquireSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse releaseSemaphoreResult(ReleaseSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.releaseSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::releaseSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse describeSemaphoreResult(DescribeSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.describeSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::describeSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse describeSemaphoreChanged(DescribeSemaphoreChangedResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.describeSemaphoreChanged(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::describeSemaphoreChanged{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse createSemaphoreResult(CreateSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.createSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::createSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse updateSemaphoreResult(UpdateSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.updateSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::updateSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    static CoordinationSessionResponse deleteSemaphoreResult(DeleteSemaphoreResultResponse response) {
        return new CoordinationSessionResponse() {
            @Override
            public <R> R match(Cases<R> cases) {
                return cases.deleteSemaphoreResult(response);
            }
            @Override
            public int hashCode() {
                return Objects.hash(response);
            }
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CoordinationSessionResponse)) {
                    return false;
                }
                CoordinationSessionResponse sessionResponse = (CoordinationSessionResponse) obj;
                return sessionResponse.match(new Cases<>() {
                    @Override
                    public Boolean ping(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean pong(PingPongResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean failure(FailureResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStarted(SessionStartedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean sessionStopped(SessionStoppedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphorePending(AcquireSemaphorePendingResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean acquireSemaphoreResult(AcquireSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean releaseSemaphoreResult(ReleaseSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreResult(DescribeSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean describeSemaphoreChanged(DescribeSemaphoreChangedResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean createSemaphoreResult(CreateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean updateSemaphoreResult(UpdateSemaphoreResultResponse otherResponse) {
                        return false;
                    }
                    @Override
                    public Boolean deleteSemaphoreResult(DeleteSemaphoreResultResponse otherResponse) {
                        return Objects.equals(response, otherResponse);
                    }
                });
            }
            @Override
            public String toString() {
                return "CoordinationSessionResponse::deleteSemaphoreResult{"
                        + "request=" + response
                        + '}';
            }
        };
    }

    <R> R match(Cases<R> cases);

    interface Cases<O> {

        O ping(PingPongResponse response);

        O pong(PingPongResponse response);

        O failure(FailureResponse response);

        O sessionStarted(SessionStartedResponse response);

        O sessionStopped(SessionStoppedResponse response);

        O acquireSemaphorePending(AcquireSemaphorePendingResponse response);

        O acquireSemaphoreResult(AcquireSemaphoreResultResponse response);

        O releaseSemaphoreResult(ReleaseSemaphoreResultResponse response);

        O describeSemaphoreResult(DescribeSemaphoreResultResponse response);

        O describeSemaphoreChanged(DescribeSemaphoreChangedResponse response);

        O createSemaphoreResult(CreateSemaphoreResultResponse response);

        O updateSemaphoreResult(UpdateSemaphoreResultResponse response);

        O deleteSemaphoreResult(DeleteSemaphoreResultResponse response);
    }

}
