package ru.yandex.intranet.d.datasource.coordination.model.session;

import java.util.Arrays;
import java.util.Objects;

/**
 * Create semaphore request. Used to create a new semaphore.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateSemaphoreRequest {

    private final long reqId;
    private final String name;
    private final long limit;
    private final byte[] data;

    public CreateSemaphoreRequest(long reqId, String name, long limit, byte[] data) {
        this.reqId = reqId;
        this.name = name;
        this.limit = limit;
        this.data = data;
    }

    /**
     * Get client-defined request id, echoed in the response.
     * @return Client-defined request id.
     */
    public long getReqId() {
        return reqId;
    }

    /**
     * Get name of the semaphore to create.
     * @return Name of the semaphore to create.
     */
    public String getName() {
        return name;
    }

    /**
     * Get number of tokens that may be acquired by sessions.
     * @return Number of tokens that may be acquired by sessions.
     */
    public long getLimit() {
        return limit;
    }

    /**
     * Get user-defined data that is attached to the semaphore.
     * @return User-defined data that is attached to the semaphore.
     */
    public byte[] getData() {
        return data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateSemaphoreRequest that = (CreateSemaphoreRequest) o;
        return reqId == that.reqId &&
                limit == that.limit &&
                Objects.equals(name, that.name) &&
                Arrays.equals(data, that.data);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(reqId, name, limit);
        result = 31 * result + Arrays.hashCode(data);
        return result;
    }

    @Override
    public String toString() {
        return "CreateSemaphoreRequest{" +
                "reqId=" + reqId +
                ", name='" + name + '\'' +
                ", limit=" + limit +
                ", data=" + Arrays.toString(data) +
                '}';
    }

}
